<?php 
	/*
		File Name	: 	widget-aboutus-icons.php
		Date		: 	28 Oct 2022
		
		Theme Name	: 	Judah Vinjai
		Author		: 	Irudayamani
		Author URI	: 	https://www.judahsoftware.in/
		Description	: 	About us icons
	*/
	
	class Judah_Widgets_Aboutus_Icons extends WP_Widget  {
		function __construct() {
			parent::__construct(
				'judah_widget_aboutus_icons', 
				__('Judah Widget - About us icons', 'judahvinjai'), 
				array( 'description' => __( 'About us icons', 'judahvinjai' ), ) 
			);
		}
		 
		// Creating widget front-end
		function widget( $args, $instance ) {
			$title 			= 	apply_filters( 'widget_title', $instance['title'] );
			$heading 		= 	$instance['heading'];
			$image1			= 	$instance['image1'];
			$content_text1	=	$instance['content_text1'];
			$image2			= 	$instance['image2'];
			$content_text2	=	$instance['content_text2'];
			$image3			= 	$instance['image3'];
			$content_text3	=	$instance['content_text3'];
			
			if ( !empty ( $image1 ) ){
				echo $args['before_widget'];
				
				echo $args['before_title_cont'];
				echo $args['before_title'];
				echo $title;
				echo $args['after_title'];
				echo $args['before_heading'];
				echo $heading;
				echo $args['after_heading'];
				echo $args['after_title_cont'];
				
				echo $args['before_content_cont'];
				
				echo $args['before_content_cont2'];
				echo $args['before_image'];
				echo $image1;
				echo $args['after_image'];
				echo $args['before_text'];
				echo $content_text1;
				echo $args['after_text'];
				echo $args['after_content_cont2'];
				
				echo $args['before_content_cont2'];
				echo $args['before_image'];
				echo $image2;
				echo $args['after_image'];
				echo $args['before_text'];
				echo $content_text2;
				echo $args['after_text'];
				echo $args['after_content_cont2'];

				echo $args['before_content_cont2'];
				echo $args['before_image'];
				echo $image3;
				echo $args['after_image'];
				echo $args['before_text'];
				echo $content_text3;
				echo $args['after_text'];
				echo $args['after_content_cont2'];
				
				echo $args['after_content_cont'];
				
				echo $args['after_widget'];
			}
		}
		
		function form( $instance ) {
			if ( isset ( $instance[ 'title' ] ) ):
				$title = $instance[ 'title' ];
			else: 
				$title = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'heading' ] ) ):
				$heading = $instance[ 'heading' ];
			else: 
				$heading = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'image1' ] ) ):
				$image1 = $instance[ 'image1' ];
			else: 
				$image1 = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'content_text1' ] ) ):
				$content_text1 = $instance[ 'content_text1' ];
			else: 
				$content_text1 = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'image2' ] ) ):
				$image2 = $instance[ 'image2' ];
			else: 
				$image2 = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'content_text2' ] ) ):
				$content_text2 = $instance[ 'content_text2' ];
			else: 
				$content_text2 = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'image3' ] ) ):
				$image3 = $instance[ 'image3' ];
			else: 
				$image3 = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'content_text3' ] ) ):
				$content_text3 = $instance[ 'content_text3' ];
			else: 
				$content_text3 = __( '', 'judahvinjai' );
			endif;
?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" placeholder="Title" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'heading' ); ?>"><?php _e( 'Heading:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'heading' )); ?>" type="text" placeholder="Heading" value="<?php echo esc_attr( $heading ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'image1' ); ?>"><?php _e( 'Icon 1:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'image1' )); ?>" type="text" placeholder="Copy and paste the image url" value="<?php echo esc_attr( $image1 ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'content_text1' ); ?>"><?php _e( 'Content 1:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'content_text1' )); ?>" type="text" placeholder="Content 1" value="<?php echo esc_attr( $content_text1 ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'image2' ); ?>"><?php _e( 'Icon 2:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'image2' )); ?>" type="text" placeholder="Copy and paste the image url" value="<?php echo esc_attr( $image2 ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'content_text2' ); ?>"><?php _e( 'Content 2:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'content_text2' )); ?>" type="text" placeholder="Content 2" value="<?php echo esc_attr( $content_text2 ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'image3' ); ?>"><?php _e( 'Icon 3:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'image3' )); ?>" type="text" placeholder="Copy and paste the image url" value="<?php echo esc_attr( $image3 ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'content_text3' ); ?>"><?php _e( 'Content 3:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'content_text3' )); ?>" type="text" placeholder="Content 3" value="<?php echo esc_attr( $content_text3 ); ?>" />
			</p>
			
<?php 
		}
			 
		function update( $new_instance, $old_instance ) {
			$instance 					= 	array();
			$instance['title'] 			= 	( ! empty( $new_instance['title'] ) ) ? $new_instance['title'] : '';
			$instance['heading']		= 	( ! empty( $new_instance['heading'] ) ) ? $new_instance['heading'] : '';
			$instance['image1'] 		= 	( ! empty( $new_instance['image1'] ) ) ? strip_tags( $new_instance['image1'] ) : '';
			$instance['image2'] 		= 	( ! empty( $new_instance['image2'] ) ) ? strip_tags( $new_instance['image2'] ) : '';
			$instance['image3'] 		= 	( ! empty( $new_instance['image3'] ) ) ? strip_tags( $new_instance['image3'] ) : '';
			$instance['content_text1'] 	= 	( ! empty( $new_instance['content_text1'] ) ) ? strip_tags( $new_instance['content_text1'] ) : '';
			$instance['content_text2'] 	= 	( ! empty( $new_instance['content_text2'] ) ) ? strip_tags( $new_instance['content_text2'] ) : '';
			$instance['content_text3'] 	=	( ! empty( $new_instance['content_text3'] ) ) ? strip_tags( $new_instance['content_text3'] ) : '';
			
			return $instance;
		}
	} 
?>
