<?php 
	/*
		File Name	: 	header-page.php
		Date		: 	28 Oct 2022
		
		Theme Name	: 	Judah Vinjai
		Author		: 	Irudayamani
		Author URI	: 	https://www.judahsoftware.in/
		Description	: 	Header of theme
	*/
	
?>

<!DOCTYPE html>
<html lang="ta">
	<head>
		<?php 
			// displays some meta tags, shortcut icon and apple-touch-icon
			do_action ( 'judah_get_shortcut_icons' ); 
			if ( has_post_thumbnail() ){
				do_action ( 'judah_get_open_graph_tags', wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large', false )[0], get_the_title(), get_bloginfo( 'name' ), get_permalink(get_the_id()) ); 
			} else {
				do_action ( 'judah_get_open_graph_tags', '', get_the_title(), get_bloginfo( 'name' ), get_permalink(get_the_id()) ); 
			}
			
			wp_head();
		?>
	</head>
	
	<body <?php body_class(); ?>>
		<div class="container-fluid">
			<div class="row js-sticky js-bk-page" id="js-header">
				<div class="col">
					<header class="js-header ps-4 pe-2">
						<div class="row">
							<div class="col-md-2">
								<div class="js-logo-cont pb-md-4">
									<?php 
										if ( has_custom_logo() ){
											the_custom_logo();
										} else {
											do_action ( 'judah_get_logo' );
										}
									?>									
								</div>
							</div>
							<div class="col-md-10">
								<?php do_action ( 'judah_show_top_menu' ); ?>
							</div>
						</div>
						<div class="row">
							<div class="col ps-0 pe-0">
								<div class="js-menu-cont">
									<nav class="navbar navbar-expand-md navbar-light pt-0 pb-0">
										<div class="container-fluid ps-0 pe-0">
											<?php do_action ( 'judah_show_main_menu' ); ?>
										</div>
									</nav>
								</div>
							</div>
						</div>
					</header>
				</div>
			</div>
