<?php
	/*
		File Name	: 	functions.php
		Date		: 	14 Oct 2022
		
		Theme Name	: 	Judah Vinjai
		Author		: 	Irudayamani
		Author URI	: 	https://www.judahsoftware.in/
		Description	: 	Main functions of theme
	*/
	
	if ( !defined ( "THEME_NAME" ) ) 	define ( "THEME_NAME", 'Judah Vinjai' );
	if ( !defined ( "TEXTDOMAIN" ) ) 	define ( "TEXTDOMAIN", 'judahvinjai' );
	if ( !defined ( "OPTION_NAME" ) ) 	define ( "OPTION_NAME", 'judah_options' );
	
	// Register Menu Locations
	register_nav_menus( array (
		'top-menu'		=>	esc_html__( 'Top Menu', TEXTDOMAIN ),
		'main-menu'		=>	esc_html__( 'Main Menu', TEXTDOMAIN ),
		'footer-menu'	=>	esc_html__( 'Footer Menu', TEXTDOMAIN ),
	) );
	
	/* Theme Options */
	require 'admin/inc/load-css-scripts.php';
	require 'admin/theme-options.php';
	require 'admin/inc/theme-support.php';
	require 'admin/inc/sidebar-init.php';
	require 'admin/inc/widget-init.php';
	require 'admin/inc/menu.php';
	require 'admin/inc/shortcodes.php';
	
	//require 'admin/templates/blocks/block-patterns.php';
	
	/*require 'admin/inc/posts.php';
	 */
	
	function judah_get_address(){
		if ( get_option ( OPTION_NAME ) ) {

			echo '<a class="ml-n2 d" href="' . esc_url ( home_url () ) . '">';
			judah_get_logo_name_colour();
			echo '</a>';
			
			$judah_theme_options	=	get_option ( OPTION_NAME );
			if ( array_key_exists ( 'address', $judah_theme_options ) ) {
				echo '<p class="">';
				echo $judah_theme_options['address'];
				echo '</p>';
			}
		}
	}
	add_action ( 'judah_get_address', 'judah_get_address' );
	
	function judah_get_logo(){
		$html	=	'<a href="' . esc_url ( home_url () ) . '">';
		$logo_html	=	'';
		if ( get_option ( OPTION_NAME ) ) {
			$judah_theme_options	=	get_option ( OPTION_NAME );
			if ( array_key_exists ( 'logo_file_name', $judah_theme_options ) ) {
				$html	.=	'<img class="js-logo" id="js-logo" src="';
				$html	.=	$judah_theme_options['logo_file_name'];
				$html	.=	'" alt="';
				$html	.=	get_bloginfo ( 'name' );
				$html	.=	' logo">';
				
				$logo_html	.= '<script>';
				$logo_html	.= 'localStorage.setItem("LOGO", "' . $judah_theme_options['logo_file_name'] . '")';
				$logo_html	.= '</script>';
			}
		}
		
		$html	.=	'</a>';
		
		echo $html;
		echo $logo_html;
	}
	
	add_action ( 'judah_get_logo', 'judah_get_logo', 1 );
	
	function judah_get_logo_sticky(){
		$logo_html	=	'';
		if ( get_option ( OPTION_NAME ) ) {
			$judah_theme_options	=	get_option ( OPTION_NAME );
			if ( array_key_exists ( 'stickylogo_file_name', $judah_theme_options ) ) {
				$logo_html	.= '<script>';
				$logo_html	.= 'localStorage.setItem("STICKYLOGO", "' . $judah_theme_options['stickylogo_file_name'] . '")';
				$logo_html	.= '</script>';
			}
		}
		
		echo $logo_html;
	}
	
	add_action ( 'judah_get_logo', 'judah_get_logo_sticky', 2 );
	
	function judah_get_logo_only(){
		$html	=	'';
		if ( get_option ( OPTION_NAME ) ) {
			$judah_theme_options	=	get_option ( OPTION_NAME );
			if ( array_key_exists ( 'logo_file_name', $judah_theme_options ) ) {
				$html	.=	$judah_theme_options['logo_file_name'];
			}
		}
		
		return $html;
	}
	
	function judah_get_logo_name(){
		if ( get_option ( OPTION_NAME ) ) {
			$judah_theme_options	=	get_option ( OPTION_NAME );
			if ( array_key_exists ( 'logo_name', $judah_theme_options ) ) {
				$html	=	'<img class="js-logo-name" src="';
				$html	.=	$judah_theme_options['logo_name'];
				$html	.=	'" alt="';
				$html	.=	get_bloginfo ( 'name' );
				$html	.=	' logo name">';
				
				echo $html;
			}
		}
	}
	add_action ( 'judah_get_logo_name', 'judah_get_logo_name' );
	
	function judah_get_logo_name_colour(){
		if ( get_option ( OPTION_NAME ) ) {
			$judah_theme_options	=	get_option ( OPTION_NAME );
			if ( array_key_exists ( 'logo_name_colour', $judah_theme_options ) ) {
				$html	=	'<img class="js-logo-name-colour" id="js-logo-name" src="';
				$html	.=	$judah_theme_options['logo_name_colour'];
				$html	.=	'" alt="';
				$html	.=	get_bloginfo ( 'name' );
				$html	.=	' logo name">';
				
				echo $html;
			}
		}
	}
	
	function judah_get_social_media_links(){
		$html	=	'';
		if ( get_option ( OPTION_NAME ) ) {
			$judah_theme_options	=	get_option ( OPTION_NAME );
			if ( array_key_exists ( 'social_fb', $judah_theme_options ) ) {
				if ( strlen ( $judah_theme_options['social_fb'] ) > 10 ) {
					$html	.=	'<a class="js-col-blue pt-4 pe-4" target="_blank" href="';
					$html	.=	$judah_theme_options['social_fb'];
					$html	.=	'"><i class="fab fa-facebook-f fa-fw js-social"></i></a>';
				}
			}
			
			if ( array_key_exists ( 'social_yt', $judah_theme_options ) ) {
				if ( strlen ( $judah_theme_options['social_yt'] ) > 10 ) {
					$html	.=	'<a class="js-col-red pt-4 pe-4" target="_blank" href="';
					$html	.=	$judah_theme_options['social_yt'];
					$html	.=	'"><i class="fab fa-youtube js-social"></i></a>';
				}
			}
			
			if ( array_key_exists ( 'social_tw', $judah_theme_options ) ) {
				if ( strlen ( $judah_theme_options['social_tw'] ) > 10 ) {
					$html	.=	'<a class="js-col-red pt-4 pe-4" target="_blank" href="';
					$html	.=	$judah_theme_options['social_tw'];
					$html	.=	'"><i class="fab fa-twitter-square js-social"></i></a>';
				}
			}
			
			if ( array_key_exists ( 'social_ig', $judah_theme_options ) ) {
				if ( strlen ( $judah_theme_options['social_ig'] ) > 10 ) {
					$html	.=	'<a class="js-col-red pt-4 pe-4" target="_blank" href="';
					$html	.=	$judah_theme_options['social_ig'];
					$html	.=	'"><i class="fab fa-instagram js-social js-social-ig"></i></a>';
				}
			}
			
			echo $html;
		}
	}
	add_action ( 'judah_get_social_media_links', 'judah_get_social_media_links' );
	
	// Meta tags in the head section
	function judah_meta_details(){
		$html	=	'<meta charset="utf-8">';
		$html	.=	'<meta name="viewport" content="width=device-width, initial-scale=1">';
		$html	.=	'<meta http-equiv="Cache-control" content="public">';
		
		echo $html;
	}
	
	add_action ( 'judah_get_shortcut_icons', 'judah_meta_details', 1 );
	
	// Shortcut icon
	function judah_shortcut_icon(){
		$html	=	'';
		if ( get_option ( OPTION_NAME ) ) {
			$judah_theme_options	=	get_option ( OPTION_NAME );
			if ( array_key_exists ( 'favicon_file_name', $judah_theme_options ) ) {
				$html	=	'<link rel="shortcut icon" href="' . $judah_theme_options['favicon_file_name'] . '"/>';
			}
		}
		echo $html;
	}
	
	add_action ( 'judah_get_shortcut_icons', 'judah_shortcut_icon', 2 );
	
	// Apple touch icon
	function judah_apple_touch_icon(){
		$html	=	'';
		if ( get_option ( OPTION_NAME ) ) {
			$judah_theme_options	=	get_option ( OPTION_NAME );
			if ( array_key_exists ( 'favicon_file_name', $judah_theme_options ) ) {
				$html	=	'<link rel="apple-touch-icon" href="' . $judah_theme_options['favicon'] . '"/>';
			}
		}
		echo $html;
	}
	
	add_action ( 'judah_get_shortcut_icons', 'judah_apple_touch_icon', 3 );
	
	// Open graph meta details
	function judah_get_open_graph_tags( $image, $title, $blog_name, $permalink ){
		$html	=	'';
		
		if( $image == '' ){
			$image	=	judah_get_logo_only();
		}
		
		$html	.=	'<meta property="og:image" content="' . $image . '" />';
		$html	.=	'<meta property="og:image:type" content="image/png" />';
		$html	.=	'<meta property="og:title" content="' . $title . " | " . $blog_name . '"/>';
		//$html	.=	'<meta property="og:image:width" content="436">';
		//$html	.=	'<meta property="og:image:height" content="228">''
		$html	.=	'<meta property="og:description" content=""/>';
		$html	.=	'<meta property="og:url" content="' . $permalink . '"/>';
		$html	.=	'<meta property="og:type" content="website"/>';
		
		echo $html;
	}
	
	add_action ( 'judah_get_open_graph_tags', 'judah_get_open_graph_tags', 5, 4 );
	
	// Insert an image from image gallery
	function judah_insert_image() {
		if ( isset ( $_GET['id'] ) ){
			$image	=	wp_get_attachment_image( filter_input ( INPUT_GET, 'id', FILTER_VALIDATE_INT ), 'medium', false, array( 'id' => 'judah_logo_preview_image' ) );
			$url	=	wp_get_attachment_url( filter_input ( INPUT_GET, 'id', FILTER_VALIDATE_INT ) );
			
			$data	=	array(
				'image'    	=> 	$image,
				'imageurl'	=>	$url,
			);
			
			wp_send_json_success( $data );
		} else {
			wp_send_json_error();
		}
	}
	
	add_action( 'wp_ajax_judah_insert_image', 'judah_insert_image' );
	
	
	// removes auto <p> tag from page / post contents
	remove_filter('the_content', 'wpautop');
	
	// remove auto <p> tag from contact form 7
	add_filter( 'wpcf7_autop_or_not', '__return_false' );
	
	// Insert loader
	function judah_get_loader(){
		$file_name	=	get_template_directory_uri() . '/images/status.gif';
		$html	=	'<div class="js-ajax-loader" id="ajax_loading_display">';
		$html	.=	'<img src="' . $file_name . '" alt="Loader">';
		$html	.=	'</div>';
		
		echo $html;
	}
	
	add_action( 'judah_get_loader', 'judah_get_loader' );
	