<?php
	/*
		File Name	: 	admin/inc/load-css-scripts.php
		Date		: 	06 Nov 2021
		
		Theme Name	: 	Judah Vinjai
		Author		: 	Irudayamani
		Author URI	: 	https://www.judahsoftware.in/
		Description	: 	Load css and scripts
	*/
	
	// Load css, js and jquery
	function judah_enqueue_styles() {
		if ( !is_admin() ) {
			$css_file	=	ABSPATH . 'wp-content/themes/judah-vinjai/assets/css/judah-vinjai-style.css';
			$js_file	=	ABSPATH . 'wp-content/themes/judah-vinjai/assets/js/judah-theme.js';
			
			wp_enqueue_style ( 'judah-bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css', array(), '', 'all' );
			wp_enqueue_style ( 'judah-font-awesome', 'https://use.fontawesome.com/releases/v5.6.3/css/all.css', array(), '', 'all' );
			wp_enqueue_style ( 'judah-animations', get_stylesheet_directory_uri() . '/assets/css/animations.css', array(), '', 'all' );
			wp_enqueue_style ( 'judah-main', get_stylesheet_directory_uri() . '/style.css', array(), '', 'all' );
			wp_enqueue_style ( 'judah-custom', get_stylesheet_directory_uri() . '/assets/css/judah-vinjai-style.css', array(), filemtime( $css_file ), 'all' );
			
			/* The following script would be loaded in the footer sections. true is for footer */
			wp_enqueue_script( 'bootstrap-bundle-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/js/bootstrap.bundle.min.js', array(), '', true );
			wp_enqueue_script( 'judah-theme-js', get_stylesheet_directory_uri() . '/assets/js/judah-theme.js', array('jquery'), filemtime( $js_file ), true );
		}
	}
	add_action ( 'wp_enqueue_scripts', 'judah_enqueue_styles' );
	
	// Login form logo
	function my_login_logo() 
	{ ?>
		<style type="text/css">
			#login h1 a, .login h1 a { background-image: url(<?php echo judah_get_logo_only(); ?>); height:100px; width:auto; background-size:contain; background-repeat:no-repeat; } 
		</style>
	<?php }
	
	add_action( 'login_enqueue_scripts', 'my_login_logo' );
	
	function judah_load_block() {
		$js_file	=	ABSPATH . 'wp-content/themes/judah-vinjai/assets/js/judah-blocks.js';
		wp_enqueue_script( 'judah-block', get_stylesheet_directory_uri() . '/assets/js/judah-blocks.js', array('wp-blocks','wp-editor'), filemtime( $js_file ),true );
	}

	add_action( 'enqueue_block_editor_assets', 'judah_load_block' );
?>