<?php 

	/*

		File Name	: 	widget-categories.php

		Date		: 	13 Nov 2021

		

		Theme Name	: 	Judah Vathanam

		Author		: 	Irudayamani

		Author URI	: 	https://www.judahsoftware.in/

		Description	: 	Display categories widget in back end and contents in front end

	*/

	

	class Judah_Widgets_Categories extends WP_Widget 

	{	function __construct() 

		{	parent::__construct(

				'judah_widget_categories', 

				__('Judah Widget - Categories', TEXTDOMAIN), 

				array( 'description' => __( 'List of categories', TEXTDOMAIN ), ) 

			);

		}



		// Creating widget front-end

		function widget( $args, $instance ) 

		{	static $first_dropdown = true;

			

			$title			=	apply_filters( 'widget_title', $instance['title'] );

			$count        	= ! empty( $instance['count'] ) ? '1' : '0';

			$hierarchical	= ! empty( $instance['hierarchical'] ) ? '1' : '0';

			$dropdown     	= ! empty( $instance['dropdown'] ) ? '1' : '0';

			

			echo $args['before_widget'];

			

			if ( ! empty( $title ) ) {

				echo $args['before_title'] . $title . $args['after_title'];

			}

			

			$ExcludeCat			=	$instance['category'];

			$ExcludeCat 		= 	str_replace(', ', ',', $ExcludeCat);

			$ExcludeCategory	=	explode ( ',', $ExcludeCat );

			

			$ijk 				= 	0;

			$ids 				= 	array();

			

			while ( $ijk < count ( $ExcludeCategory ) ){

				$idObj 			= 	get_category_by_slug ( $ExcludeCategory[$ijk] ); 

				$ids[] 			= 	$idObj->term_id;

				$ijk++;

			}



			/* $categories = get_categories( array(

				'orderby'		=>	'name',

				'show_count'	=> 	$count,

				'hierarchical'	=> 	$hierarchical,

				'order'   		=>	'ASC',

				//'parent'  		=>	0,

				'exclude' 		=>	$ids

			) ); */

			

			$cat_args = array(

				'orderby'		=>	'name',

				'show_count'	=> 	$count,

				'hierarchical'	=> 	$hierarchical,

				'order'   		=>	'ASC',

				//'parent'  		=>	0,

				'exclude' 		=>	$ids

			);

			

			if ( $dropdown ) {

				printf( '<form class="js-category-form" action="%s" method="get">', esc_url( home_url() ) );

				$dropdown_id    = ( $first_dropdown ) ? 'cat' : "{$this->id_base}-dropdown-{$this->number}";

				$first_dropdown = false;



				//echo '<label class="screen-reader-text" for="' . esc_attr( $dropdown_id ) . '">' . $title . '</label>';



				$cat_args['show_option_none'] =	__( 'Select Category' );

				$cat_args['id']               =	$dropdown_id;



				wp_dropdown_categories( apply_filters( 'widget_categories_dropdown_args', $cat_args, $instance ) );



				echo '</form>';



				$type_attr = current_theme_supports( 'html5', 'script' ) ? '' : ' type="text/javascript"';

?>



	<script<?php echo $type_attr; ?>>

	/* <![CDATA[ */

	(function() {

		var dropdown = document.getElementById( "<?php echo esc_js( $dropdown_id ); ?>" );

		function onCatChange() {

			if ( dropdown.options[ dropdown.selectedIndex ].value > 0 ) {

				dropdown.parentNode.submit();

			}

		}

		dropdown.onchange = onCatChange;

	})();

	/* ]]> */

	</script>



				<?php

			} else {

				$format = current_theme_supports( 'html5', 'navigation-widgets' ) ? 'html5' : 'xhtml';



				/** This filter is documented in wp-includes/widgets/class-wp-nav-menu-widget.php */

				$format = apply_filters( 'navigation_widgets_format', $format );



				if ( 'html5' === $format ) {

					// The title may be filtered: Strip out HTML and make sure the aria-label is never empty.

					$title      = trim( strip_tags( $title ) );

					$aria_label = $title ? $title : $default_title;

					echo '<nav role="navigation" aria-label="' . esc_attr( $aria_label ) . '">';

				}

				?>



				<ul>

					<?php

						$cat_args['title_li'] = '';



						wp_list_categories( apply_filters( 'widget_categories_args', $cat_args, $instance ) );

					?>

				</ul>



				<?php

				if ( 'html5' === $format ) {

					echo '</nav>';

				}

			}

			

			/* foreach( $categories as $category ) {

				$category_link = sprintf( 

					'<a href="%1$s">%2$s</a>',

					esc_url( get_category_link( $category->term_id ) ),

					esc_html( $category->name )

				);



				echo '<p class="js-category '.$SelectedClass.'">' . sprintf( esc_html__( '%s', 'textdomain' ), $category_link ) . '</p> ';

			} */

			echo $args['after_widget'];

		}



		function form( $instance ) 

		{	if(isset($instance[ 'title' ])) 

			{ 	$title 		= 	$instance[ 'title' ]; 

				$category 	= 	$instance[ 'category' ]; 

			}

			else { $title = __( 'New title', TEXTDOMAIN ); $category = ''; $number = 5; }

			

			$count        = isset( $instance['count'] ) ? (bool) $instance['count'] : false;

			$hierarchical = isset( $instance['hierarchical'] ) ? (bool) $instance['hierarchical'] : false;

			$dropdown     = isset( $instance['dropdown'] ) ? (bool) $instance['dropdown'] : false;

?>

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', TEXTDOMAIN ); ?></label> 

				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />

			</p>



			<p>

				<label><?php _e( 'Exclude category (Category Slug):', TEXTDOMAIN ); ?></label>

				<input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'category' )); ?>" type="text" value="<?php echo esc_attr( $category ); ?>" >

			</p>

			<p>

				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'dropdown' ); ?>" name="<?php echo $this->get_field_name( 'dropdown' ); ?>"<?php checked( $dropdown ); ?> />

				<label for="<?php echo $this->get_field_id( 'dropdown' ); ?>"><?php _e( 'Display as dropdown' ); ?></label>

			<br />



				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'count' ); ?>" name="<?php echo $this->get_field_name( 'count' ); ?>"<?php checked( $count ); ?> />

				<label for="<?php echo $this->get_field_id( 'count' ); ?>"><?php _e( 'Show post counts' ); ?></label>

			<br />



				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'hierarchical' ); ?>" name="<?php echo $this->get_field_name( 'hierarchical' ); ?>"<?php checked( $hierarchical ); ?> />

				<label for="<?php echo $this->get_field_id( 'hierarchical' ); ?>"><?php _e( 'Show hierarchy' ); ?></label>

			</p>

<?php 

		}

	 

		function update( $new_instance, $old_instance ) 

		{	$instance 					= array();

			$instance['title'] 			= ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

			$instance['category'] 		= ( ! empty( $new_instance['category'] ) ) ? strip_tags( $new_instance['category'] ) : '';

			$instance['count']			= ! empty( $new_instance['count'] ) ? 1 : 0;

			$instance['hierarchical']	= ! empty( $new_instance['hierarchical'] ) ? 1 : 0;

			$instance['dropdown']		= ! empty( $new_instance['dropdown'] ) ? 1 : 0;

			return $instance;

		}

	} 

?>