<?php 

	/*

		File Name	: 	widget-adbanner.php

		Date		: 	30 Jun 2022

		

		Theme Name	: 	Judah Vathanam

		Author		: 	Irudayamani

		Author URI	: 	https://www.judahsoftware.in/

		Description	: 	Class to display adbanner

	*/

	

	class Judah_Widget_AdBanner extends WP_Widget 

	{	function __construct() 

		{	parent::__construct(

				'judah_widget_adbanner', 

				__('Judah Widget - Ad Banner', TEXTDOMAIN), 

				array( 'description' => __( 'Display advertisement banner', TEXTDOMAIN ), 'icon' => 'heading', ) 

			);

		}

		 

		// Creating widget front-end

		function widget( $args, $instance ) {

			$title	=	apply_filters( 'widget_title', $instance['title'] );

			$link	=	$instance['link'];

			

			if ( !empty ( $link ) ) {

				$linkto	=	$instance['linkto'];

				echo $args['before_widget'];

				echo $args['before_title'];

				echo $title;

				echo $args['after_title'];

				

				echo $args['before_content'];

				echo '<a href="' . $linkto . '" target="_blank">';

				echo '<img class="img-fluid mx-auto d-block zoom" src="' . $link . '" alt="Advertisement">';

				echo '</a>';

				echo $args['after_content'];

				

				echo $args['after_widget'];

			}

		}

		

		function form( $instance ) {

			if ( isset ( $instance[ 'title' ] ) ) {

				$title = $instance[ 'title' ];

			} else {

				$title = __( '', TEXTDOMAIN );

			}

			if ( isset ( $instance[ 'link' ] ) ) {

				$link = $instance[ 'link' ];

			} else {

				$link = __( '', TEXTDOMAIN );

			}

			if ( isset ( $instance[ 'linkto' ] ) ) {

				$linkto = $instance[ 'linkto' ];

			} else {

				$linkto = __( '', TEXTDOMAIN );

			}

?>

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', TEXTDOMAIN ); ?></label> 

				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" placeholder="Title" value="<?php echo esc_attr( $title ); ?>" />

			</p>

			<p>

				<label><?php _e( 'Image Url:', TEXTDOMAIN ); ?></label>

				<input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'link' )); ?>" type="text" placeholder="Image Url" value="<?php echo esc_attr( $link ); ?>" >

			</p>

			<p>

				<label><?php _e( 'Link to Url', TEXTDOMAIN ); ?></label>

				<input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'linkto' )); ?>" type="text" placeholder="Image Url" value="<?php echo esc_attr( $linkto ); ?>" >

			</p>

<?php 

		}

			 

		function update( $new_instance, $old_instance ) {

			$instance 				= 	array();

			$instance['title'] 		= 	( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

			$instance['link'] = 	( ! empty( $new_instance['link'] ) ) ? strip_tags( $new_instance['link'] ) : '';

			$instance['linkto'] = 	( ! empty( $new_instance['linkto'] ) ) ? strip_tags( $new_instance['linkto'] ) : '';

			return $instance;

		}

	} 

	

	 register_widget( 'Judah_Widget_AdBanner' );

?>

