<?php
	/*
		File Name		: menu.php
		Date				: 14 Oct 2022
		Theme Name	: Judah Vinjai
		Author			: Irudayamani
		Author URI	: https://www.judahsoftware.in/
		Description	: Menus
	*/
	
	/* Top Menu */
	function JudahTopMenu(){
		$MainMenuBar			=	'';
		$MenuName 				= 'top-menu';
		$class_li					=	'nav-item js-dropdown';
		$class_a					=	'nav-link js-nav-link';
		
		if ( ( $MenuLocations = get_nav_menu_locations() ) && isset( $MenuLocations[$MenuName] ) ) {
			$MainMenu 			= wp_get_nav_menu_object( $MenuLocations[$MenuName] );
		  
			$MenuItems 			= wp_get_nav_menu_items ( $MainMenu->term_id );
			$menu_list 			=	'';
			$sub_menu_list	=	'';
			$count 					= 0;
			
			foreach ( $MenuItems as $MenuItem ) {
				if ( $MenuItem->menu_item_parent == 0 ) {
					// Main Menu with / without submenu items
					if ( $sub_menu_list != '' ){
						$sub_menu_list	=	'<div class="js-dropdown-content">' . $sub_menu_list . '</div>';
						$menu_list			.=	$sub_menu_list . '</li>';
						$sub_menu_list	=	'';
					}
					
					$caret_icon				=	'';
					if ( isset ( $MenuItems[$count + 1] ) && $MenuItems[$count + 1]->menu_item_parent > 0 ){
						$caret_icon			=	' <i class="fa fa-caret-down"></i>';
					}
					
					$menu_list .= '<li class="' . $class_li . '">';
					$menu_list .= '<a href="' . $MenuItem->url . '" class=" ' . $class_a . '">' . $MenuItem->title . $caret_icon . ' </a>';
				} else {
					// submenu items
					$sub_menu_list .= '<a href="' . $MenuItem->url . '" class=" ' . $class_a . '">' . $MenuItem->title . '</a>';
				}
				
				$count++;
			}
		} else {
			$menu_list = '';
		}

		$MainMenuBar	.=	'<div class="js-topnav mt-2 mt-md-0">';
		$MainMenuBar	.=	'<ul class="nav js-nav" id="js-nav">';
		$MainMenuBar	.=	$menu_list;
		$MainMenuBar	.=	'</ul>';		
		$MainMenuBar	.=	'<a href="javascript:void(0);" class="js-icon-bar" onclick="ShowHideItmMenuBar()">';
		$MainMenuBar	.=	'<i class="fa fa-bars"></i>';
		$MainMenuBar	.=	'</a>';
		$MainMenuBar	.=	'</div>';
		
		echo $MainMenuBar;
	}
	add_action ( 'judah_show_top_menu', 'JudahTopMenu' );
	
	/* Main Menu */
	function JudahMainMenu(){
		$MainMenuBar			=	'';
		$MenuName 				= 'main-menu';
		$class_li					=	'nav-item js-dropdown';
		$class_a					=	'nav-link js-nav-link';
		
		if ( ( $MenuLocations = get_nav_menu_locations() ) && isset( $MenuLocations[$MenuName] ) ) {
			$MainMenu 			= wp_get_nav_menu_object( $MenuLocations[$MenuName] );
		  
			$MenuItems 			= wp_get_nav_menu_items ( $MainMenu->term_id );
			$menu_list 			=	'';
			$sub_menu_list	=	'';
			$count 					= 0;
			
			foreach ( $MenuItems as $MenuItem ) {
				if ( $MenuItem->menu_item_parent == 0 ) {
					// Main Menu with / without submenu items
					if ( $sub_menu_list != '' ){
						$sub_menu_list	=	'<div class="js-dropdown-content">' . $sub_menu_list . '</div>';
						$menu_list			.=	$sub_menu_list . '</li>';
						$sub_menu_list	=	'';
					}
					
					$caret_icon				=	'';
					if ( isset ( $MenuItems[$count + 1] ) && $MenuItems[$count + 1]->menu_item_parent > 0 ){
						$caret_icon			=	' <i class="ps-1 fa fa-caret-down"></i>';
					}
					
					$menu_list .= '<li class="' . $class_li . '">';
					$menu_list .= '<a href="' . $MenuItem->url . '" class=" ' . $class_a . '"><span class="js-span">' . $MenuItem->title . $caret_icon . '</span></a>';
				} else {
					// submenu items
					$sub_menu_list .= '<a href="' . $MenuItem->url . '" class=" ' . $class_a . '"><span class="js-span2">' . $MenuItem->title . '</span></a>';
				}
				
				$count++;
			}
		} else {
			$menu_list = '';
		}




		$MainMenuBar	.=	'<nav id="js_main_menu" class="navbar navbar-expand-sm navbar-dark sticky-top ps-lg-5 pe-lg-5">';
		$MainMenuBar	.=	'<div class="container-fluid">';
		$MainMenuBar	.=	'<a class="navbar-brand" href="' . esc_url ( home_url () ) . '">';
		$MainMenuBar	.=	'<div class="js-logo-cont pb-md-2">';

		if ( has_custom_logo() ){
			$MainMenuBar	.=	get_the_custom_logo();
		} else {
			$MainMenuBar	.=	judah_get_logo();
		}

		$MainMenuBar	.=	'</div>';
		$MainMenuBar	.=	'</a>';

		$MainMenuBar	.=	'<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#jsNavBarTop">';
		$MainMenuBar	.=	'<span class="navbar-toggler-icon"></span>';
		$MainMenuBar	.=	'</button>';
		$MainMenuBar	.=	'<div class="collapse navbar-collapse justify-content-end" id="jsNavBarTop">';
		$MainMenuBar	.=	'<div class="js-topnav mt-2 mt-md-0">';
		$MainMenuBar	.=	'<ul class="nav d-inline js-nav" id="js-nav">';
		$MainMenuBar	.=	$menu_list;
		$MainMenuBar	.=	'</ul>';
		$MainMenuBar	.=	'<a href="" class="btn btn-success js-btn-enquire">Enquire Now</a>';
		$MainMenuBar	.=	'</div>';
		$MainMenuBar	.=	'</div>';
		
		$MainMenuBar	.=	'</div>';
		$MainMenuBar	.=	'</nav>';
		
		echo $MainMenuBar;
	}
	add_action ( 'judah_show_main_menu', 'JudahMainMenu' );
	
	/* Footer Menu */
	function JudahFooterMenu() {
		$MenuName 				= 'footer-menu';
		$MenuClass				=	'nav-item';	//li
		$ActiveMenuClass	=	'nav-item active-menu';
		$MenuClassA				=	'nav-link js-menu-item-bottom';	//a
		$ActiveMenuClassA	=	'nav-link js-menu-item-bottom active-menu';
		$CurrentActiveItem=	0; 
		$CurrentParentId	=	0;
		
		if ( ( $MenuLocations = get_nav_menu_locations() ) && isset( $MenuLocations[ $MenuName ] ) ) {
			$MainMenu 	= 	wp_get_nav_menu_object( $MenuLocations[ $MenuName ] );
		  
			$MenuItems 	= 	wp_get_nav_menu_items($MainMenu->term_id);
			$MenuList 	=	'';
			$count 		= 	0;
			$SubMenu 	= 	false;
			$CurrentParentId		=	get_the_id();
			
			if ( is_array ( $MenuItems ) ) {
				foreach ( $MenuItems as $current ) {
					if ( $CurrentParentId == $current->object_id ){
						if ( !$current->menu_item_parent ) {
							$CurrentParentId = $current->ID;
						} else {
							$CurrentParentId = $current->menu_item_parent; 
						}
						
						$CurrentActiveItem = $current->ID;
						break;
					}
				}
				
				foreach ( $MenuItems as $MenuItem ) {
					$Link 	= 	$MenuItem->url;
					$Title 	= 	$MenuItem->title;
					$MenuItem->ID == $CurrentActiveItem ? $ActiveMenuClassA = $ActiveMenuClassA : $ActiveMenuClassA = $MenuClassA;
					
					if ( !$MenuItem->menu_item_parent ) {
						$ParentId = $MenuItem->ID; 
						$ParentId == $CurrentParentId ? $ActiveMenuClass = $ActiveMenuClass : $ActiveMenuClass = $MenuClass;
						
						if ( !empty ( $MenuItems[$count + 1] ) && $MenuItems[ $count + 1 ]->menu_item_parent == $ParentId ){
							$MenuList .= '<li class="dropdown has_child' . $ActiveMenuClass . '"><a href="' . $Link . '" class="dropdown-toggle' . $ActiveMenuClassA . '" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><span class="nav-span"></span>' . $Title . '<span class="caret"></span></a>';
						} else {
							$MenuList .= '<li class="pt-2 pb-2 ' . $ActiveMenuClass . '">' . "\n";
							$MenuList .= '<a href="' . $Link . '" class="d-inline ' . $ActiveMenuClassA . '">' . $Title . '</a>' . "\n";
						}
					}
				
					if ( empty ( $MenuItems[$count + 1] ) || $MenuItems[ $count + 1 ]->menu_item_parent != $ParentId ) {
						$MenuList .= '</li>' ."\n";      
						$SubMenu = false;
					}
					
					$count++;
				}
			}
		} else {
			//$MenuList = '<li>Menu "' . $MenuName . '" not defined.</li>';
			$MenuList = '';
		}

		$MainMenuBar 	=	'<div class="">';
		$MainMenuBar	.=	'<ul class="navbar-nav">';
		$MainMenuBar	.=	$MenuList;
		$MainMenuBar	.=	'</ul>';
		$MainMenuBar	.=	'</div>';
		
		echo $MainMenuBar;
	}
	add_action ( 'judah_show_footer_menu', 'JudahFooterMenu' );
	
	/* Footer Menu Two */
	function JudahFooterMenuTwo() {
		$MenuName 				= 'footer-menu-2';
		$MenuClass				=	'nav-item';	//li
		$ActiveMenuClass	=	'nav-item active-menu';
		$MenuClassA				=	'nav-link js-menu-item-bottom';	//a
		$ActiveMenuClassA	=	'nav-link js-menu-item-bottom active-menu';
		$CurrentActiveItem=	0; 
		$CurrentParentId	=	0;
		
		if ( ( $MenuLocations = get_nav_menu_locations() ) && isset( $MenuLocations[ $MenuName ] ) ) {
			$MainMenu 	= 	wp_get_nav_menu_object( $MenuLocations[ $MenuName ] );
		  
			$MenuItems 	= 	wp_get_nav_menu_items($MainMenu->term_id);
			$MenuList 	=	'';
			$count 		= 	0;
			$SubMenu 	= 	false;
			$CurrentParentId		=	get_the_id();
			
			if ( is_array ( $MenuItems ) ) {
				foreach ( $MenuItems as $current ) {
					if ( $CurrentParentId == $current->object_id ){
						if ( !$current->menu_item_parent ) {
							$CurrentParentId = $current->ID;
						} else {
							$CurrentParentId = $current->menu_item_parent; 
						}
						
						$CurrentActiveItem = $current->ID;
						break;
					}
				}
				
				foreach ( $MenuItems as $MenuItem ) {
					$Link 	= 	$MenuItem->url;
					$Title 	= 	$MenuItem->title;
					$MenuItem->ID == $CurrentActiveItem ? $ActiveMenuClassA = $ActiveMenuClassA : $ActiveMenuClassA = $MenuClassA;
					
					if ( !$MenuItem->menu_item_parent ) {
						$ParentId = $MenuItem->ID; 
						$ParentId == $CurrentParentId ? $ActiveMenuClass = $ActiveMenuClass : $ActiveMenuClass = $MenuClass;
						
						if ( !empty ( $MenuItems[$count + 1] ) && $MenuItems[ $count + 1 ]->menu_item_parent == $ParentId ){
							$MenuList .= '<li class="dropdown has_child' . $ActiveMenuClass . '"><a href="' . $Link . '" class="dropdown-toggle' . $ActiveMenuClassA . '" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><span class="nav-span"></span>' . $Title . '<span class="caret"></span></a>';
						} else {
							$MenuList .= '<li class="pt-2 pb-2 ' . $ActiveMenuClass . '">' . "\n";
							$MenuList .= '<a href="' . $Link . '" class="d-inline ' . $ActiveMenuClassA . '">' . $Title . '</a>' . "\n";
						}
					}
				
					if ( empty ( $MenuItems[$count + 1] ) || $MenuItems[ $count + 1 ]->menu_item_parent != $ParentId ) {
						$MenuList .= '</li>' ."\n";      
						$SubMenu = false;
					}
					
					$count++;
				}
			}
		} else {
			//$MenuList = '<li>Menu "' . $MenuName . '" not defined.</li>';
			$MenuList = '';
		}

		$MainMenuBar 	=	'<div class="">';
		$MainMenuBar	.=	'<ul class="navbar-nav">';
		$MainMenuBar	.=	$MenuList;
		$MainMenuBar	.=	'</ul>';
		$MainMenuBar	.=	'</div>';
		
		echo $MainMenuBar;
	}
	add_action ( 'judah_show_footer_menu_two', 'JudahFooterMenuTwo' );
?>