<?php
	/*
		File Name	: 	judahoptions-settings.php
		Date		: 	22 Jun 2022
		
		Theme Name	: 	Judah Vathanam
		Author		: 	Irudayamani
		Author URI	: 	https://www.judahsoftware.in/
		Description	: 	Include theme options
	*/
	
	function judah_options_settings() {
		if ( !get_option ( OPTION_NAME ) ) {
			add_option ( OPTION_NAME );
		}
		
		$id	=	'judah_options_settings_section';
		
		// define atleast one section
		add_settings_section(
			'judah_options_settings_section',				// unique identifier for section
			__( 'Options of theme', TEXTDOMAIN ),			// section title
			'judah_options_settings_section_callback',		// callback for an optional description
			TEXTDOMAIN										// admin page / textdomain to add section to
		);
		
		// Logo
		add_settings_field(
			'judah_options_settings_logo',					// unique identifier for field
			__( 'Logo<br><span class="js-para-normal">If you set custom logo this will be overriden by custom logo.</span>', TEXTDOMAIN ),						// field title
			'judah_options_settings_logo_callback',			// callback for field markup
			TEXTDOMAIN,										// admin page / textdomain to show the markup
			$id												// section to display in
		);
		
		// Logo for sticky menu
		add_settings_field(
			'judah_options_settings_sticky_logo',			// unique identifier for field
			__( 'Sticky Logo', TEXTDOMAIN ),				// field title
			'judah_options_settings_sticky_logo_callback',	// callback for field markup
			TEXTDOMAIN,										// admin page / textdomain to show the markup
			$id												// section to display in
		);
		
		/* add_settings_field(
			'judah_options_settings_logo_name',
			__( 'Logo Name', TEXTDOMAIN ),						// field title
			'judah_options_settings_logo_name_callback',
			TEXTDOMAIN,
			$id
		); */
		
		/* add_settings_field(
			'judah_options_settings_logo_name_colour',
			__( 'Logo Name in Colour', TEXTDOMAIN ),						// field title
			'judah_options_settings_logo_name_colour_callback',
			TEXTDOMAIN,
			$id
		); */
		
		// Favicon
		add_settings_field(
			'judah_options_settings_favicon',					// unique identifier for field
			__( 'Favicon', TEXTDOMAIN ),
			'judah_options_settings_favicon_callback',			// callback for field markup
			TEXTDOMAIN,											// admin page / textdomain to show the markup
			$id													// section to display in
		);
		
		
		add_settings_field(
			'judah_options_settings_address',					// unique identifier for field
			__( 'Address<br><span class="js-text-0p8">(appears in the footer area)</span>', TEXTDOMAIN ),					// field title
			'judah_options_settings_address_callback',			// callback for field markup
			TEXTDOMAIN,											// admin page / textdomain to show the markup
			$id													// section to display in
		);
		
		add_settings_field(
			'judah_options_settings_social_fb',
			__( 'Facebook', TEXTDOMAIN ),
			'judah_options_settings_social_fb_callback',
			TEXTDOMAIN,
			$id
		);
		
		add_settings_field(
			'judah_options_settings_social_yt',
			__( 'YouTube', TEXTDOMAIN ),
			'judah_options_settings_social_yt_callback',
			TEXTDOMAIN,
			$id
		);
		
		add_settings_field(
			'judah_options_settings_social_tw',
			__( 'Twitter', TEXTDOMAIN ),
			'judah_options_settings_social_tw_callback',
			TEXTDOMAIN,
			$id
		);
		
		add_settings_field(
			'judah_options_settings_social_ig',
			__( 'Instagram', TEXTDOMAIN ),
			'judah_options_settings_social_ig_callback',
			TEXTDOMAIN,
			$id
		);
		
		register_setting(
			OPTION_NAME,
			OPTION_NAME
		);
	}
	add_action ( 'admin_init', 'judah_options_settings' );
	
	function judah_options_settings_section_callback() {
		esc_html_e ( 'This sections sets various elements which is required for theme', TEXTDOMAIN );
		//echo get_admin_page_title ();
		//echo ABSPATH;
	}
	
	// logo call back function
	function judah_options_settings_logo_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value		=	'';
		$image_id	=	0;
		$index		=	1;
		
		if ( isset ( $options['logo'] ) ) {
			$image_id	=	esc_html( $options['logo'] );
		}
		if ( isset ( $options['logo_file_name'] ) ) {
			$value	=	esc_html( $options['logo_file_name'] );
		}
		
		if( intval( $image_id ) > 0 ) {
			// Change with the image size you want to use
			$image 	= 	wp_get_attachment_image( $image_id, 'medium', false, array( 'id' => 'judah_preview_image_' . $index ) );
			$value	=	wp_get_attachment_url( $image_id );
		} else {
			// Some default image
			$mage_url	=	get_stylesheet_directory_uri() . '/images/judah-logo.png';
			$image 	= 	'<img id="judah_preview_image_' . $index . '" class="mt-4 js-logo-thumb d-block" src="' . $mage_url . '"/>';
		}

		echo '<input type="disabled" name="judah_options[logo_file_name]" id="judah_media_file_name_' . $index . '" class="form-control" style="width:75%!important; display:inline-block" value="' . $value . '">';
		echo '<input type="button" class="ms-4 button-primary js-open-media" style="display:inline-block" value="Select an Image" id="judah_media_manager_' . $index . '"/>';
		echo '<input type="hidden" name="judah_options[logo]" id="judah_media_file_' . $index . '" value="' . esc_attr( $image_id ) . '" class="regular-text" />';
		
		echo $image;
		
	}
	
	// sticky logo call back function
	function judah_options_settings_sticky_logo_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value		=	'';
		$image_id	=	0;
		$index		=	4;
		
		if ( isset ( $options['stickylogo'] ) ) {
			$image_id	=	esc_html( $options['stickylogo'] );
		}
		if ( isset ( $options['stickylogo_file_name'] ) ) {
			$value	=	esc_html( $options['stickylogo_file_name'] );
		}
		
		if( intval( $image_id ) > 0 ) {
			// Change with the image size you want to use
			$image 	= 	wp_get_attachment_image( $image_id, 'medium', false, array( 'id' => 'judah_preview_image_' . $index ) );
			$value	=	wp_get_attachment_url( $image_id );
		} else {
			// Some default image
			$mage_url	=	get_stylesheet_directory_uri() . '/images/judah-logo.png';
			$image 	= 	'<img id="judah_preview_image_' . $index . '" class="mt-4 js-logo-thumb d-block" src="' . $mage_url . '"/>';
		}

		echo '<input type="disabled" name="judah_options[stickylogo_file_name]" id="judah_media_file_name_' . $index . '" class="form-control" style="width:75%!important; display:inline-block" value="' . $value . '">';
		echo '<input type="button" class="ms-4 button-primary js-open-media" style="display:inline-block" value="Select an Image" id="judah_media_manager_' . $index . '"/>';
		echo '<input type="hidden" name="judah_options[stickylogo]" id="judah_media_file_' . $index . '" value="' . esc_attr( $image_id ) . '" class="regular-text" />';
		
		echo $image;
		
	}
	function judah_options_settings_logo_name_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value		=	'';
		$image_id	=	0;
		$index		=	2;
		
		if ( isset ( $options['logo_name'] ) ) {
			$image_id	=	esc_html( $options['logo_name'] );
		}
		if ( isset ( $options['logo_name_file_name'] ) ) {
			$value	=	esc_html( $options['logo_name_file_name'] );
		}
		
		if( intval( $image_id ) > 0 ) {
			// Change with the image size you want to use
			$image 	= 	wp_get_attachment_image( $image_id, 'medium', false, array( 'id' => 'judah_preview_image_' . $index ) );
			$value	=	wp_get_attachment_url( $image_id );
		} else {
			// Some default image
			$mage_url	=	get_stylesheet_directory_uri() . '/images/judah-logo.png';
			$image 	= 	'<img id="judah_preview_image_' . $index . '" class="mt-4 js-logo-thumb d-block" src="' . $mage_url . '"/>';
		}

		echo '<input type="disabled" name="judah_options[logo_name_file_name]" id="judah_media_file_name_' . $index . '" class="form-control" style="width:75%!important; display:inline-block" value="' . $value . '">';
		echo '<input type="button" class="ms-4 button-primary js-open-media" style="display:inline-block" value="Select an Image" id="judah_media_manager_' . $index . '"/>';
		echo '<input type="hidden" name="judah_options[logo_name]" id="judah_media_file_' . $index . '" value="' . esc_attr( $image_id ) . '" class="regular-text" />';
		
		echo $image;
		
	}
	
	/* function judah_options_settings_logo_name_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value	=	'';
		
		if ( isset ( $options['logo_name'] ) ) {
			$value	=	esc_html( $options['logo_name'] );
		}
		echo '<input type="text" name="judah_options[logo_name]" id="judah_options[logo_name]" class="form-control" value="' . $value . '">';
	} */
	
	function judah_options_settings_logo_name_colour_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value	=	'';
		
		if ( isset ( $options['logo_name_colour'] ) ) {
			$value	=	esc_html( $options['logo_name_colour'] );
		}
		echo '<input type="text" name="judah_options[logo_name_colour]" id="judah_options[logo_name_colour]" class="form-control" value="' . $value . '">';
	}
	
	function judah_options_settings_favicon_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value		=	'';
		$image_id	=	0;
		$index		=	3;
		
		if ( isset ( $options['favicon'] ) ) {
			$image_id	=	esc_html( $options['favicon'] );
		}
		if ( isset ( $options['favicon_file_name'] ) ) {
			$value	=	esc_html( $options['favicon_file_name'] );
		}
		
		if( intval( $image_id ) > 0 ) {
			// Change with the image size you want to use
			$image 	= 	wp_get_attachment_image( $image_id, 'medium', false, array( 'id' => 'judah_preview_image_' . $index ) );
			$value	=	wp_get_attachment_url( $image_id );
		} else {
			// Some default image
			$mage_url	=	get_stylesheet_directory_uri() . '/images/judah-logo.png';
			$image 	= 	'<img id="judah_preview_image_' . $index . '" class="mt-4 js-logo-thumb d-block" src="' . $mage_url . '"/>';
		}
		
		//echo '<input type="text" name="judah_options[favicon]" id="judah_options[favicon]" class="form-control" value="' . $value . '">';
		echo '<input type="disabled" name="judah_options[favicon_file_name]" id="judah_media_file_name_' . $index . '" class="form-control" style="width:75%!important; display:inline-block" value="' . $value . '">';
		echo '<input type="button" class="ms-4 button-primary js-open-media" style="display:inline-block" value="Select an Image" id="judah_media_manager_' . $index . '"/>';
		echo '<input type="hidden" name="judah_options[favicon]" id="judah_media_file_' . $index . '" value="' . esc_attr( $image_id ) . '" class="regular-text" />';
		
		echo $image;
		
	}
	
	function judah_options_settings_address_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value		=	'';
		
		if ( isset ( $options['address'] ) ) {
			$value	=	esc_html( $options['address'] );
		}
		echo '<textarea rows="6" name="judah_options[address]" id="judah_options[address]" class="form-control">' . $value . '</textarea>';
	}
	
	function judah_options_settings_social_fb_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value		=	'';
		
		if ( isset ( $options['social_fb'] ) ) {
			$value	=	esc_html( $options['social_fb'] );
		}
		echo '<input type="text" name="judah_options[social_fb]" id="judah_options[social_fb]" class="form-control" value="' . $value . '">';
	}
	
	function judah_options_settings_social_yt_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value		=	'';
		
		if ( isset ( $options['social_yt'] ) ) {
			$value	=	esc_html( $options['social_yt'] );
		}
		echo '<input type="text" name="judah_options[social_yt]" id="judah_options[social_yt]" class="form-control" value="' . $value . '">';
	}
	
	function judah_options_settings_social_tw_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value		=	'';
		
		if ( isset ( $options['social_tw'] ) ) {
			$value	=	esc_html( $options['social_tw'] );
		}
		echo '<input type="text" name="judah_options[social_tw]" id="judah_options[social_tw]" class="form-control" value="' . $value . '">';
	}
	
	function judah_options_settings_social_ig_callback() {
		$options	=	get_option ( OPTION_NAME );
		$value		=	'';
		
		if ( isset ( $options['social_ig'] ) ) {
			$value	=	esc_html( $options['social_ig'] );
		}
		echo '<input type="text" name="judah_options[social_ig]" id="judah_options[social_ig]" class="form-control" value="' . $value . '">';
	}
	
?>