<?php
	/*
		File Name	: 	footer.php
		Date		: 	14 Oct 2022
		
		Theme Name	: 	Judah Vinjai
		Author		: 	Irudayamani
		Author URI	: 	https://www.judahsoftware.in/
		Description	: 	footer section of theme
	*/
?>
		<div class="row js-footer">
			<div class="col ps-0 pe-0">
				<footer class="">
					<div class="container mb-2">
						<div class="row">
							<div class="col-md-3 mt-4">
								<div class="js-logo-cont-f">
									<a href="<?php echo esc_url ( home_url () ); ?>">
										<?php 
											if ( has_custom_logo() ){
												the_custom_logo();
											} else {
												do_action ( 'judah_get_logo' );
											}
										?>
									</a>
								</div>
								<?php do_action ( 'judah_get_address' ); ?>
							</div>
							<div class="col-md-3 mt-4">
								<h5 class="js-bb text-center text-md-start js-red">Services</h5>
								<?php do_action ( 'judah_show_footer_menu' ); ?>
							</div>
							<div class="col-md-3 mt-4">
								<h5 class="js-bb text-center text-md-start js-red">Get in touch</h5>
								<?php
									if ( is_active_sidebar( 'sidebar-footer-4' ) ) {
										dynamic_sidebar( 'sidebar-footer-4' );
									}
								?>
							</div>
							<div class="col-md-3 mt-4">
								<h5 class="js-bb text-center text-md-start js-red">Follow Us</h5>
								<div class="js-social-cont">
									<?php do_action ( 'judah_get_social_media_links' ); ?>
								</div>
							</div>
						</div>
					</div>
					<div class="container-fluid bg-dark">
						<div class="row">
							<div class="col">
								<div class="container">
									<div class="row">
										<div class="col-md-7 mt-3">
											<p class="text-white text-center text-md-start mb-0 pt-3">© <?php echo date( 'Y' ); ?> Vinjai Ads. All Rights Reserved. </p>
										</div>
										<div class="col-md-5 mt-3">
											<p class="text-white text-center text-md-end js-text-0p75">WordPress Theme developed by 
												<a href="https://www.judahsoftware.in/" target="_blank">
													<img class="" style="width:30px;" src="https://www.judahsoftware.in/wp-content/uploads/2020/04/judah-software-logo.gif" alt="Judah Software">
												</a>
												Judah Software
											</p>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php wp_footer(); ?> 
				</footer>
			</div>
		</div>
		<?php do_action ( 'judah_get_loader' ); ?>
	</body>
</html>