<?php
	/*
		File Name		: functions.php
		Date				: 14 Oct 2022
		Theme Name	: Judah Vinjai
		Author			:	Irudayamani
		Author URI	:	https://www.judahsoftware.in/
		Description	:	Main functions of theme
	*/
	
	add_shortcode('aboutus_icons', 'aboutus_icons');
	function aboutus_icons ( $atts, $content=null ){
		
		if ( is_active_sidebar( 'sidebar-about-us-icons' ) ) {
			dynamic_sidebar( 'sidebar-about-us-icons' );
		}
	}

	// shortcode
	// [judah-display-slider category_name="slider" post_count="5"]
	function judah_display_slider( $attr ) {
		$post_count	=	0;
		$category		=	'';
		$html				=	'';
		
		
		if ( isset ( $attr['category_name'] ) ) $category 	= $attr['category_name'];
		if ( isset ( $attr['post_count'] ) ) 		$post_count = $attr['post_count'];
		
		if ( $post_count == 0 || $category == '' ) return $html;
		
		$args = array(
			'posts_per_page'	=>	$post_count,
			'offset' 					=> 	0,
			'category_name' 	=> 	$category,
			'orderby' 				=> 	'post_date',
			'order' 					=> 	'DESC',
			'include' 				=> 	'',
			'exclude' 				=> 	'',
			'meta_key' 				=> 	'',
			'meta_value' 			=>	'',
			'post_type' 			=> 	'post',
			'post_status' 		=> 	'publish',
			'suppress_filters'=> 	true,
		);
		
		$CategoryPosts = new WP_Query( $args );
		wp_reset_postdata();
		
		if($CategoryPosts->have_posts()) {
			while($CategoryPosts->have_posts()){
			 	$CategoryPosts->the_post();
				
				$html	.=	'<div class="carousel-item active">';
				$html	.=	'<img class="d-block img img-fluid" src="' . get_the_post_thumbnail_url ( $CategoryPosts->post_id, 'large' ) . '" alt="Vinjai Ads">';
				$html	.=	'<div class="js-carousal-capt-cont">';
				$html	.=	'<a href="' . esc_url ( get_permalink() ) . '">';
				$html	.=	'<h3 class="js-carousal-h3">' . wp_trim_words ( get_the_title(), 12 ) . '</h3>';
				$html	.=	'</a>';
				$html	.=	'<a href="' . esc_url ( get_permalink() ) . '">';
				$html	.=	'<p class="js-carousal-p">' . wp_trim_words ( get_the_excerpt(), 25 ) . '</p>';
				$html	.=	'</a>';
				$html	.=	'<a href="' . site_url() . '/about-us" class="btn btn-success text-white mt-md-4 js-btn-enquire">Know more <span><i class="fa-solid fa-arrow-right-long fa-fw"></i></span></a>';
				$html	.=	'</div>';
				$html	.=	'</div>';
			}
		}
		
		if ( $html != '' ) {
			
			$html	=	'<div class="carousel-inner">' . $html . '</div>';
			
			/* $html	.=	'<button class="carousel-control-prev" type="button" data-bs-target="#js-carousal" data-bs-slide="prev">';
			$html	.=	'<span class="carousel-control-prev-icon"></span>';
			$html	.=	'</button>';
			$html	.=	'<button class="carousel-control-next" type="button" data-bs-target="#js-carousal" data-bs-slide="next">';
			$html	.=	'<span class="carousel-control-next-icon"></span>';
			$html	.=	'</button>'; */
			
			$html	=	'<div class="row"><div class="col pb-4"><div id="js-carousal" class="carousel slide js-carousal" data-bs-ride="carousel">' . $html . '</div></div></div>';
		}
		
		return $html;
	}
	add_shortcode( "judah-display-slider", "judah_display_slider" );

	// [judah-display-progress title="Progress Indicator" headings="Ad Films,Photography,Designing" values="98,98,97"]
	add_shortcode( "judah-display-progress", "judah_display_progress" );
	function judah_display_progress( $attr ) {
		$i				=	0;
		$html			=	'';
		$headings	=	'';
		$values		=	'';
		$sec_h		=	[];
		$sec_v		=	[];
		
		if ( isset ( $attr['headings'] ) ) 	$headings = $attr['headings'];
		if ( isset ( $attr['values'] ) ) 		$values 	= $attr['values'];
		
		$sec_h		=	explode ( ',', $headings );
		$sec_v		=	explode ( ',', $values );
		
		foreach ( $sec_h as $heading ){
			$html	.=	'<div class="js-ibcb">';
			$html	.=	'<div class="js-ibh">' . $heading . '</div>';
			$html	.=	'<div class="js-ibhn">' . ( isset ( $sec_v[$i] ) ? $sec_v[$i] . '%' : 0 ) . '</div>';
			$html	.=	'<div class="js-ibc">';
			$html	.=	'<div id="js-ib-' . $i . '" class="js-ib" jsimv="' . ( isset ( $sec_v[$i] ) ? $sec_v[$i] : 0 ) . '" style="width:0%"></div>';
			$html	.=	'</div>';
			$html	.=	'</div>';
			
			$i++;
		}
		
		$html	.=	'<input type="hidden" id="jsib_count" value="' . $i . '">';
		
		return $html;
	}
?>