/*

	File Name	: 	admin/assets/js/judah-media.js

	Date		: 	24 Jun 2022

	

	Theme Name	: 	Judah Vathanam

	Author		: 	Irudayamani

	Author URI	: 	https://www.judahsoftware.in/

	Description	: 	Media support to select image from theme settings page

*/



jQuery(document).ready( function($) {



	jQuery('input.js-open-media').click(function(e) {

		var ElmId = this.id;

		

		spArray = ElmId.split("_");

		var IndexNum = spArray[spArray.length - 1];

		var ImagePrevId = "judah_preview_image_" + IndexNum;

		var ImageFileName = "judah_media_file_name_" + IndexNum;

		var MediaFile = "input#judah_media_file_" + IndexNum;

		

		e.preventDefault();

		var image_frame;

		

		if(image_frame){

			image_frame.open();

		}

		

		// Define image_frame as wp.media object

		image_frame = wp.media({

		title: 'Select Media',

			multiple : false,

			library : {

				type : 'image',

			}

		});



		image_frame.on('close',function() {

			// On close, get selections and save to the hidden input

			// plus other AJAX stuff to refresh the image preview

			var selection =  image_frame.state().get('selection');

			var gallery_ids = new Array();

			var index_no = 0;

			

			selection.each(function(attachment) {

				gallery_ids[index_no] = attachment['id'];

				index_no++;

			});

			

			var ids = gallery_ids.join(",");

			if(ids.length === 0) return true;//if closed withput selecting an image

			jQuery(MediaFile).val(ids);

			RefreshImage(ids, ImagePrevId, ImageFileName);

		});



		image_frame.on('open',function() {

			// On open, get the id from the hidden input

			// and select the appropiate images in the media manager

			var selection =  image_frame.state().get('selection');

			var ids = jQuery(MediaFile).val().split(',');

			

			ids.forEach(function(id) {

				var attachment = wp.media.attachment(id);

				attachment.fetch();

				selection.add( attachment ? [ attachment ] : [] );

			});



		});



		image_frame.open();

	});



});



// Ajax request to refresh the image preview

function RefreshImage(the_id, img_tid, img_did){

	var data = {

		action: 'judah_insert_image',

		id: the_id

	};

	

	img_tid	=	"#"+img_tid;

	img_did	=	"#"+img_did;

	

	jQuery.get(ajaxurl, data, function(response) {

		if(response.success === true) {

			jQuery(img_tid).replaceWith( response.data.image );

			jQuery(img_did).val(response.data.imageurl );

		}

	});

}